<?php
if ( ! session_id() ) @ session_start();
extract($_GET);

include_once('../home.php');
require_once('../assets/dbManager.php');

dbManager::setQueryLogging(false);
dbManager::configFile('../assets/dbconfig.php');

$fil = array();

$conn_string = "host=".IPS." port=".DBPORT." dbname=".DBN." user=".DBUSER." password=".DBPASS."";
$dbconn = pg_connect($conn_string);

if (!$dbconn) {
    die('Sin conexión de base de datos...');
}

$sql = 'INSERT INTO estacion_contador (id_estacion,id_resp_estacion,id_tipo_combustible,id_tipo_estacion_contador,nu_lts_estacion_contador,fe_act_estacion_contador,fe_dia_estacion_contador,co_referencia) 
        VALUES ($1,$2,$3,$4,$5,$6,$7,$8) 
        ON CONFLICT (co_referencia)
            DO
            UPDATE
                SET nu_lts_estacion_contador = $5,
                    fe_act_estacion_contador = $6';
                    
$result = pg_prepare($dbconn, "ins_query", $sql);
if (!$result) {
    die('No se puede preparar la Inserción...');
}

$callback = isset($_GET['callback']) ? preg_replace('/[^a-z0-9$_]/si', '', $_GET['callback']) : false;
header('Content-Type: ' . ($callback ? 'application/javascript' : 'application/json') . ';charset=UTF-8');

$usr = base64_decode($usr);
$ide = base64_decode($ide);
$tco = base64_decode($tco);
$ttp = base64_decode($ttp);
$lts = base64_decode($lts);
$hoy = date("Y-m-d H:i:s");

$unq = date("Ymd").$ide.$tco.$ttp;

$err = 'IDE:'.$ide.', USR:'.$usr.', TCO:'.$tco.', TMP:'.$ttp.', LTS:'.$lts.', HOY:'.$hoy.', HOY:'.$hoy;

if ($lts <= 0) {
    $lts = 0;
}

$data = array();

$result = pg_execute($dbconn, "ins_query", array($ide,$usr,$tco,$ttp,$lts,$hoy,$hoy,$unq));
if (!$result){
    
    $linea = array();
    $linea[] = base64_encode(0);
    $linea[] = base64_encode($err);
    $data[] = $linea;
}else{
    $linea = array();
    $linea[] = base64_encode(1);
    $linea[] = base64_encode(1);
    $data[] = $linea;
}
echo json_encode($data);
?>